package com.test.testdock;

import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import android.util.Log;

public class MainActivity extends AppCompatActivity {

    private static final String TAG = "TestDock";

    private static final String ACTION_TOPICON_DOCK_EVENT =
	"hk.topicon.intent.action.ACTION_DOCK_EVENT";

    private final BroadcastReceiver DOCK_RECEIVER = new BroadcastReceiver() {

	    @Override
	    public void onReceive(Context context, Intent intent) {
		Log.d(TAG, "onReceive");
		
		if(intent != null) {
		    Log.d(TAG, "action : " + intent.getAction() +
			  " , is plugged : " +
			  intent.getIntExtra(Intent.EXTRA_DOCK_STATE,
					     Intent.EXTRA_DOCK_STATE_UNDOCKED));
		}
	    }
	};
	    

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
    }

    @Override
    protected void onResume() {
	super.onResume();
	Log.d(TAG, "onResume");

	IntentFilter intentFilter = new IntentFilter();
	intentFilter.addAction(ACTION_TOPICON_DOCK_EVENT);
	registerReceiver(DOCK_RECEIVER, intentFilter);
    }

    @Override
    protected void onPause() {
	unregisterReceiver(DOCK_RECEIVER);
	Log.d(TAG, "onPause");
	super.onPause();
    }
}