// MyVideoWnd.cpp : implementation file
//

#include "stdafx.h"
#include "Security_DemoDlg.h"
#include "MyVideoWnd.h"
#include "MyViewManager.h"
#include "MyLayout.h"
#include "MyLiveAV.h"
#include "MySwitchLiveAV.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

typedef struct tagDSVIDEOWND
{
	MyVideoWnd* pwndSrc;
}DSVIDEOWND, *PDSVIDEOWND;

#define FMT_VIDEOWND "DSVIDEOWND"

PVOID g_pCustomChannelFullWindow = NULL;

/////////////////////////////////////////////////////////////////////////////
IMPLEMENT_DYNAMIC(MyVideoWnd, CWnd)

MyVideoWnd::MyVideoWnd() : m_pDropTarget( NULL ) , m_pViewManager( NULL ) , m_nWndID( -1 ), m_bConnectVideo( FALSE )
{
	m_nSubChannelNumber			= 0;

	m_pCustomChannelWindow		= NULL;	

	m_pLiveAV					= NULL;

	m_pSwitchLiveAV				= NULL;

	m_pParentDlg				= NULL;

	m_strShowText				= "NO SIGNAL";

	m_bFullScreen				= FALSE;

	m_pDropTarget				= new WndDropTarget<MyVideoWnd>;	
}

MyVideoWnd::~MyVideoWnd()
{
	if (m_pDropTarget) { delete m_pDropTarget; m_pDropTarget = NULL; }
}

BEGIN_MESSAGE_MAP(MyVideoWnd, CWnd)
	//{{AFX_MSG_MAP(MyVideoWnd)
	ON_WM_TIMER()
	ON_WM_PAINT()
	ON_WM_CLOSE()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_DESTROY()
	ON_WM_CHAR()
	ON_WM_ERASEBKGND()
	ON_WM_WINDOWPOSCHANGED()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// MyVideoWnd message handlers

BOOL MyVideoWnd::PreCreateWindow(CREATESTRUCT& cs) 
{	
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;

	//cs.style     |=  WS_BORDER;

	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS, ::LoadCursor(NULL, IDC_ARROW), HBRUSH(CTLCOLOR_BTN), NULL);	

	return CWnd::PreCreateWindow(cs);
}
 
void MyVideoWnd::OnWindowPosChanged( WINDOWPOS* lpwndpos )
{
	CWnd::OnWindowPosChanged( lpwndpos );
}

void MyVideoWnd::OnClose() 
{	
	CWnd::OnClose();
}

void MyVideoWnd::OnMouseMove(UINT nFlags, CPoint point) 
{
	ClientToScreen(&point);

	::SendMessage(::GetParent(m_hWnd), WM_MOUSEMOVE, 0, MAKELPARAM(point.x,point.y));	

	SetFocus();
}

void MyVideoWnd::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
    if (m_pViewManager != NULL) { m_pViewManager->Notify(this , 0); }

	GetParent()->SendMessage( WM_LBUTTONDBLCLK, 0, 0 );

	CWnd::OnLButtonDblClk(nFlags, point);
}

void MyVideoWnd::OnRButtonDown(UINT nFlags, CPoint point) 
{	
	CWnd::OnRButtonDown(nFlags, point);

	POINT point2;

	GetCursorPos( &point2 );

	if ( m_pParentDlg != NULL )
	{
		::SendMessage( m_pParentDlg->GetSafeHwnd(), WM_RBUTTONDOWN, 0, 0 );
	}
}

void MyVideoWnd::OnLButtonDown(UINT nFlags, CPoint point) 
{		
	HANDLE hData = ::GlobalAlloc (GMEM_MOVEABLE | GMEM_SHARE, sizeof (DSVIDEOWND));

	DSVIDEOWND* pDS = (DSVIDEOWND*) GlobalLock(hData);	

	pDS->pwndSrc = this;

	GlobalUnlock(hData);			// done modifying memory

    UINT nFormat = CLIPBOARD_FORMAT(FMT_VIDEOWND);

 	m_DataSource.CacheGlobalData(nFormat, hData);

	// perform the drag and drop operation
	DROPEFFECT dropEffect;

	dropEffect = m_DataSource.DoDragDrop(DROPEFFECT_COPY | DROPEFFECT_MOVE);

	//SC_DEBUG("Drop Effect : %ld", dropEffect);

	// remove the selection if this was a move operation
	if (dropEffect == DROPEFFECT_MOVE)
	{
	}

	// The OLE library eats the button up message, make the list box
	// happy by simulating another button up message.
	// PostMessage(WM_LBUTTONUP, nFlags, MAKELONG(point.x, point.y));
}

DROPEFFECT MyVideoWnd::OnDragEnter(COleDataObject *pDataObject, DWORD dwKeyState, CPoint point)
{
	return OnDragOver(pDataObject, dwKeyState, point);
}

DROPEFFECT MyVideoWnd::OnDragOver(COleDataObject *pDataObject, DWORD dwKeyState, CPoint point)
{
	DROPEFFECT	dropEffect = DROPEFFECT_NONE;

	if (pDataObject->IsDataAvailable(CLIPBOARD_FORMAT(FMT_VIDEOWND)))
	{
		dropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_COPY : DROPEFFECT_MOVE;
	}

	OnDrop(pDataObject, dropEffect, point);

	return dropEffect;
}

void MyVideoWnd::OnDragLeave()
{
}

BOOL MyVideoWnd::OnDrop(COleDataObject *pDataObject, DROPEFFECT dropEffect, CPoint point)
{
	HGLOBAL	hGlobal = pDataObject->GetGlobalData(CLIPBOARD_FORMAT(FMT_VIDEOWND));
	
	if (hGlobal == NULL)  { return FALSE; }

	DSVIDEOWND WndData = *((DSVIDEOWND*) GlobalLock(hGlobal));

	GlobalUnlock(hGlobal);
	GlobalFree(hGlobal);

	if (m_pViewManager == NULL) { return FALSE; }

	if (WndData.pwndSrc == this) { return FALSE; }

	m_pViewManager->SwapView(WndData.pwndSrc, this);

	return TRUE;
}

int MyVideoWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;	

	HWND hWnd = GetSafeHwnd();
	
	if ( m_pParentDlg != NULL )
	{
		if ( m_bFullScreen )
		{			
			// INSERT CHANNEL WINDOW TO THE VIDEO RENDERER 
			//
			g_pCustomChannelFullWindow = CVRSDK_INSERT_CHANNEL_WINDOW( m_pParentDlg->m_pCustomVideoRenderer2, hWnd );
		}
		else
		{
			// INSERT CHANNEL WINDOW TO THE VIDEO RENDERER 
			//
			m_pCustomChannelWindow = CVRSDK_INSERT_CHANNEL_WINDOW( m_pParentDlg->m_pCustomVideoRenderer1, hWnd );
		}
	}

	return 0;
}

void MyVideoWnd::SetViewManager(MyViewManager *pMgr)
{
    m_pViewManager = pMgr;
}

void MyVideoWnd::OnSize(UINT nType, int cx, int cy) 
{
	/*
	if ( m_pLiveAV != NULL )
	{
		if ( m_pLiveAV->IsConnected() )
		{
			m_pLiveAV->RefreshDisplay();
		}
	}

	if ( m_pSwitchLiveAV != NULL )
	{
		if ( m_pSwitchLiveAV->IsConnected() )
		{
			m_pSwitchLiveAV->RefreshDisplay( m_nSubChannelNumber );
		}
	}
	*/


	// FOR WINDOW RESIZE
	//
	if ( m_pParentDlg != NULL )
	{
		if ( m_pParentDlg->m_pViewManager != NULL )
		{
			m_pParentDlg->m_nActiveFullWndCH = -1;

			if ( m_pParentDlg->m_oFullVideoWnd.GetSafeHwnd() != NULL )
			{
				// RESTORE TO NORMAL WINDOW
				//
				if ( m_pParentDlg->m_oFullVideoWnd.IsWindowVisible() )
				{				
					m_pParentDlg->FullWindowToSmallWindow();

					m_pParentDlg->m_oFullVideoWnd.ShowWindow( FALSE );

					if ( m_pParentDlg->m_nSwitchType == NO_SWICTH_CARD )
					{
						if ( m_pLiveAV != NULL )
						{
							// FOR SC590 ( TW2809 ) SPECIAL CASE
							//
							if ( m_pParentDlg->m_strChipName == "TW2809" )
							{
								m_pLiveAV->LiveStop();

								int i = m_nWndID; // ID OF ACTIVE WND

								m_pLiveAV->SetVideoFormat( MAKEFOURCC('Y', 'V', '1', '2'), m_pParentDlg->m_YChInfo[ i ].nWidth, m_pParentDlg->m_YChInfo[ i ].nHeight, 12,  m_pParentDlg->m_YChInfo[ i ].dFrameRate );

								m_pLiveAV->LiveRun();								
							}

							// CVRSDK : SET CHANNEL WINDOW POINTER	
							//
							m_pLiveAV->SetCustomChannelWindow( m_pCustomChannelWindow );
						}
					}

					// SWITCH CARD
					//
					if ( m_pParentDlg->m_nSwitchType == DOUBLE_SWITCH_CARD || m_pParentDlg->m_nSwitchType == QUAD_SWITCH_CARD )
					{
						if ( m_pSwitchLiveAV != NULL )
						{
							m_pSwitchLiveAV->m_nActiveWndID = -1;

							m_pSwitchLiveAV->m_bFullScreen = FALSE;								
						}
					}

					CWnd::OnSize(nType, cx, cy);

					return;
				}
				else
				{
					if ( m_pParentDlg->m_pViewManager->IsWinMaximize() )
					{
						// SHOW FULL SCREEN WINDOW
					    //
						if ( g_pCustomChannelFullWindow != NULL )
						{
							if ( m_pParentDlg->m_nSwitchType == NO_SWICTH_CARD )
							{
								// FOR SC590 ( TW2809 ) SPECIAL CASE
								//
								if ( m_pParentDlg->m_strChipName == "TW2809" )
								{
									m_pLiveAV->LiveStop();

									if ( m_pParentDlg->m_nStandard ==  0x00000001 )  { m_pLiveAV->SetVideoFormat( MAKEFOURCC('Y', 'V', '1', '2'), 1920, 1080, 12, 29.97 ); }
									
									if ( m_pParentDlg->m_nStandard ==  0x00000010 )  { m_pLiveAV->SetVideoFormat( MAKEFOURCC('Y', 'V', '1', '2'), 1920, 1080, 12, 25.00 ); }

									m_pLiveAV->LiveRun();								
								}

								if ( m_pLiveAV != NULL )
								{
									// CVRSDK : SET CHANNEL WINDOW POINTER	
									//
									m_pLiveAV->SetCustomChannelWindow( g_pCustomChannelFullWindow );
								}
							}

							// SWITCH CARD
							//
							if ( m_pParentDlg->m_nSwitchType == DOUBLE_SWITCH_CARD || m_pParentDlg->m_nSwitchType == QUAD_SWITCH_CARD )
							{
								if ( m_pSwitchLiveAV != NULL )
								{
									m_pSwitchLiveAV->m_nActiveWndID = m_nWndID;

									m_pSwitchLiveAV->m_bFullScreen = TRUE;								
								}
							}							

							m_pParentDlg->m_nActiveFullWndCH = m_nWndID;

							m_pParentDlg->SmallWindowToFullWindow();

							m_pParentDlg->m_oFullVideoWnd.ShowWindow( TRUE );
						}
					}
				}
			}		
		}
	}

	CWnd::OnSize(nType, cx, cy);	
}

void MyVideoWnd::OnDestroy() 
{
	CWnd::OnDestroy();
}

void MyVideoWnd::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	(GetParent())->SendMessage(WM_CHAR, nChar, nFlags);

	CWnd::OnChar(nChar, nRepCnt, nFlags);
}

BOOL MyVideoWnd::OnEraseBkgnd(CDC* pDC) 
{
	if ( m_bConnectVideo == FALSE )
	{
		CDC *pDC = GetDC();

		HDC hDC = pDC->GetSafeHdc();

		CBrush  brush(RGB( 31, 43, 186 ));

		CRect rt;	GetClientRect(&rt);

		HBITMAP hBackBitmap = CreateCompatibleBitmap(hDC, rt.right - rt.left, rt.bottom - rt.top);		

		HDC hBitmapDC = ::CreateCompatibleDC(hDC);

		HBITMAP hOldBitmap = (HBITMAP)SelectObject(hBitmapDC, hBackBitmap);

		::FillRect(hBitmapDC, &rt, brush);	
			
		if ( m_bFullScreen )
		{
			DrawText(hBitmapDC, rt.Width() / 2, rt.Height() / 2, "FULL SCREEN", RGB(255, 0, 0));
		}
		else
		{
			DrawText(hBitmapDC, rt.Width() / 2, rt.Height() / 2, m_strShowText, RGB(255, 0, 0));
		}

		BitBlt(hDC, rt.left, rt.top, rt.Width(), rt.Height(), hBitmapDC, 0, 0, SRCCOPY);

		SelectObject(hBitmapDC, hOldBitmap);

		DeleteDC(hBitmapDC);

		DeleteObject(hBackBitmap);

		ReleaseDC(pDC);	
	}	

	return TRUE;

	return CWnd::OnEraseBkgnd(pDC);
}

void MyVideoWnd::DrawText(HDC hDC, int nX, int nY, CString strText, COLORREF clrColor)
{
	CDC *pDC = CDC::FromHandle( hDC );

	CPen penBlack;

	penBlack.CreatePen(PS_SOLID, 1, clrColor);

	CPen* pOldPen = pDC->SelectObject(&penBlack);

	pDC->SetTextColor(clrColor);

	pDC->SetBkColor(RGB(31, 43, 186));

	CSize txtSize;

	txtSize = pDC->GetTextExtent( strText );

	txtSize.cx = txtSize.cx / 2;
	txtSize.cy = txtSize.cy / 2;

	pDC->TextOut(nX - txtSize.cx, nY - txtSize.cy, strText);

	pDC->SelectObject(pOldPen);

	ReleaseDC(pDC);
}

void MyVideoWnd::OnPaint() 
{
	CPaintDC dc(this);	
}

LRESULT MyVideoWnd::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	return CWnd::WindowProc(message, wParam, lParam);
}

void MyVideoWnd::OnTimer(UINT nIDEvent) 
{
	CWnd::OnTimer(nIDEvent);
}


BOOL MyVideoWnd::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CWnd::PreTranslateMessage(pMsg);
}
