// AnimationFactoryDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AnimationFactory.h"
#include "AnimationFactoryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg dialog

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CAnimationFactoryDlg * g_pAnimationFactoryDlg = NULL;

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	SC_DEBUG( "on_no_signal_detected_callback()" );

	g_pAnimationFactoryDlg->m_nDeviceVideoWidth = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeight = 0;

	g_pAnimationFactoryDlg->m_bDeviceVideoIsInterleaved = FALSE;

	g_pAnimationFactoryDlg->m_dDeviceVideoFrameRate = 0.0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannel = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSample = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequency = 0;

	g_pAnimationFactoryDlg->SetTimer( 0x00000001, 1, NULL );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	SC_DEBUG( "on_no_signal_removed_callback()" );

	g_pAnimationFactoryDlg->m_nDeviceVideoWidth = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeight = 0;

	g_pAnimationFactoryDlg->m_bDeviceVideoIsInterleaved = FALSE;

	g_pAnimationFactoryDlg->m_dDeviceVideoFrameRate = 0.0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannel = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSample = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequency = 0;

	g_pAnimationFactoryDlg->SetTimer( 0x00000001, 1, NULL );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	SC_DEBUG( "on_format_changed_callback( %d, %d, %d, %2.3f, %d, %d, %d )", nVideoWidth, nVideoHeight, bVideoIsInterleaved, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

	g_pAnimationFactoryDlg->m_nDeviceVideoWidth = nVideoWidth;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeight = nVideoHeight;

	g_pAnimationFactoryDlg->m_bDeviceVideoIsInterleaved = bVideoIsInterleaved;

	g_pAnimationFactoryDlg->m_dDeviceVideoFrameRate = dVideoFrameRate;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannel = nAudioChannels;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSample = nAudioBitsPerSample;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequency = nAudioSampleFrequency;

	g_pAnimationFactoryDlg->SetTimer( 0x00000001, 1, NULL );

	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );

	if( g_pAnimationFactoryDlg->m_nShareRecordState > 0x00000000 ) {

		ULONG xo = g_pAnimationFactoryDlg->m_nDeviceVideoWidth  >> 2;

		ULONG yo = g_pAnimationFactoryDlg->m_nDeviceVideoHeight >> 2;

		ULONG cx = g_pAnimationFactoryDlg->m_nDeviceVideoWidth  >> 1;

		ULONG cy = g_pAnimationFactoryDlg->m_nDeviceVideoHeight >> 1; // JUST SHOW CENTER 1/4 PICTURE

		QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, QCAP_COLORSPACE_TYEP_YUY2, g_pAnimationFactoryDlg->m_nDeviceVideoWidth, g_pAnimationFactoryDlg->m_nDeviceVideoHeight, pFrameBuffer, nFrameBufferLen );
	
		QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX( 1, QCAP_COLORSPACE_TYEP_YUY2, g_pAnimationFactoryDlg->m_nDeviceVideoWidth, g_pAnimationFactoryDlg->m_nDeviceVideoHeight, pFrameBuffer, nFrameBufferLen, xo, yo, cx, cy );
	}
	LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );

    return QCAP_RT_OK;
}

QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );

	if( g_pAnimationFactoryDlg->m_nShareRecordState > 0x00000000 ) {

		QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );

		QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 1, pFrameBuffer, nFrameBufferLen );
	}
	LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );

    return QCAP_RT_OK;
}

CAnimationFactoryDlg::CAnimationFactoryDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAnimationFactoryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAnimationFactoryDlg)
	m_strDeviceInfo = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAnimationFactoryDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnimationFactoryDlg)
	DDX_Control(pDX, IDC_STATIC_CROP_WINDOW, m_statCropWindow);
	DDX_Control(pDX, IDC_STATIC_LIVE_WINDOW, m_statLiveWindow);
	DDX_Text(pDX, IDC_STATIC_INFO, m_strDeviceInfo);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAnimationFactoryDlg, CDialog)
	//{{AFX_MSG_MAP(CAnimationFactoryDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_START, OnButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg message handlers

extern CAnimationFactoryApp theApp;

void CAnimationFactoryDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	KillTimer( 0x00000000 );

	// STOP SHARE RECORDING
	//
	OnButtonStop();

	// UNINITIALIZE DEVICE RESOURCE
	// 
	{	EnterCriticalSection( &m_hShareRecordAccessCriticalSection );

		m_nShareRecordState = 0x00000000;

		LeaveCriticalSection( &m_hShareRecordAccessCriticalSection );

		QCAP_STOP_SHARE_RECORD( 0 );

		QCAP_STOP_SHARE_RECORD( 1 );
	}

	// UNINITIALIZE DEVICE RESOURCE
	// 
	if( m_pDevice ) {

		QCAP_STOP( m_pDevice );

		QCAP_DESTROY( m_pDevice );

		m_pDevice = NULL;
	}
	DeleteCriticalSection( &m_hShareRecordAccessCriticalSection );

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

BOOL CAnimationFactoryDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	// 
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE DEVICE RESOURCE
	// 
	g_pAnimationFactoryDlg = this;

	m_pDevice = NULL;

	m_nDeviceVideoWidth = 0;

	m_nDeviceVideoHeight = 0;

	m_bDeviceVideoIsInterleaved = FALSE;

	m_dDeviceVideoFrameRate = 0.0;

	m_nDeviceVideoFrameNumber = 0;

	m_nDeviceAudioChannel = 0;

	m_nDeviceAudioBitsPerSample= 0;

	m_nDeviceAudioSampleFrequency = 0;

	m_nShareRecordState = 0x00000000;

	InitializeCriticalSection( &m_hShareRecordAccessCriticalSection );

	// INITIALIZE DEVICE RESOURCE
	// 
	{	QCAP_SET_SYSTEM_CONFIGURATION( FALSE );
		
		QCAP_CREATE( "SA7160 PCI", 0, NULL, &m_pDevice );

		QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice, on_format_changed_callback, this );

		QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice, on_no_signal_detected_callback, this );

		QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice, on_no_signal_removed_callback, this );

		QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice, on_video_preview_callback, this );

		QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice, on_audio_preview_callback, this );

		QCAP_RUN( m_pDevice );
	}
	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAnimationFactoryDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAnimationFactoryDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAnimationFactoryDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAnimationFactoryDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CAnimationFactoryDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}


void CAnimationFactoryDlg::OnButtonStart() 
{
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here

	if( m_nDeviceVideoWidth == 0 || 
			
		m_nDeviceVideoHeight == 0 ) {

		return ;
	}
	OnButtonStop();

//	QCAP_SET_VIDEO_RECORD_PROPERTY( m_pDevice, 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8000000, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
	
	QCAP_SET_VIDEO_RECORD_PROPERTY( m_pDevice, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8000000, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

	QCAP_SET_AUDIO_RECORD_PROPERTY( m_pDevice, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

	QCAP_START_RECORD( m_pDevice, 0, "DEMO.MP4" );

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( TRUE );
}

void CAnimationFactoryDlg::OnButtonStop() 
{
	QCAP_STOP_RECORD( m_pDevice, 0 );

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );
}

void CAnimationFactoryDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000001 ) {

		KillTimer( 0x00000001 );

		if( m_nDeviceVideoWidth == 0 || 
			
			m_nDeviceVideoHeight == 0 ) {

			m_strDeviceInfo.Format( "INFO: ..." );

			OnButtonStop();

			// UNINITIALIZE SHARE RECORDING RESOURCE
			// 
			{	EnterCriticalSection( &m_hShareRecordAccessCriticalSection );

				m_nShareRecordState = 0x00000000;

				LeaveCriticalSection( &m_hShareRecordAccessCriticalSection );

				QCAP_STOP_SHARE_RECORD( 0 );

				QCAP_STOP_SHARE_RECORD( 1 );
			}
		}
		else {

			m_strDeviceInfo.Format( "INFO: %d X %d%c @ %2.3f FPS, %d CHs x %d BITS x %d HZ", m_nDeviceVideoWidth, m_nDeviceVideoHeight, m_bDeviceVideoIsInterleaved ? 'I' : 'P', m_dDeviceVideoFrameRate, m_nDeviceAudioChannel, m_nDeviceAudioBitsPerSample, m_nDeviceAudioSampleFrequency );

			// INITIALIZE SHARE RECORDING RESOURCE
			// 
			{	double fps = m_dDeviceVideoFrameRate;

				if( m_bDeviceVideoIsInterleaved ) {

					fps /= 2;
				}
				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, m_nDeviceVideoWidth >> 0, m_nDeviceVideoHeight >> 0, fps, QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, m_statLiveWindow.m_hWnd, TRUE, FALSE );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, m_nDeviceVideoWidth >> 1, m_nDeviceVideoHeight >> 1, fps, QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, m_statCropWindow.m_hWnd, TRUE, FALSE );

				QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, m_nDeviceAudioChannel, m_nDeviceAudioBitsPerSample, m_nDeviceAudioSampleFrequency, 100 );

				QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, m_nDeviceAudioChannel, m_nDeviceAudioBitsPerSample, m_nDeviceAudioSampleFrequency, 100 );

				QCAP_START_SHARE_RECORD( 0, NULL, QCAP_RECORD_FLAG_DISPLAY );

				QCAP_START_SHARE_RECORD( 1, NULL, QCAP_RECORD_FLAG_DISPLAY );

				EnterCriticalSection( &m_hShareRecordAccessCriticalSection );

				m_nShareRecordState = 0x00000001;

				LeaveCriticalSection( &m_hShareRecordAccessCriticalSection );
			}
		}
		UpdateData( FALSE );
	}	
	CDialog::OnTimer(nIDEvent);
}
