// SetupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC510.h"
#include "SC510Dlg.h"
#include "SetupDlg.h"
#include "afxdialogex.h"


// CSetupDlg dialog

IMPLEMENT_DYNAMIC(CSetupDlg, CDialog)

CSetupDlg::CSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSetupDlg::IDD, pParent)
{

}

CSetupDlg::~CSetupDlg()
{
}

void CSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetupDlg)	
	DDX_Control(pDX, IDC_BUTTON_AUDIO_INPUT, m_btnAudioInput);
	DDX_Control(pDX, IDC_EDIT_DEVICE_FORMAT_INFOMATION_4, m_editDeviceFormatInformation_4);
	DDX_Control(pDX, IDC_EDIT_DEVICE_FORMAT_INFOMATION_3, m_editDeviceFormatInformation_3);
	DDX_Control(pDX, IDC_EDIT_DEVICE_FORMAT_INFOMATION_2, m_editDeviceFormatInformation_2);
	DDX_Control(pDX, IDC_EDIT_DEVICE_FORMAT_INFOMATION_1, m_editDeviceFormatInformation_1);
	DDX_Control(pDX, IDC_CHECK_SHOW_CLONE_VIDEO, m_btnShowCloneVideo);
	DDX_Control(pDX, IDC_EDIT_JPG_PATH, m_edit_jpg);
	DDX_Control(pDX, IDC_EDIT_BMP_PATH, m_edit_bmp);
	DDX_Control(pDX, IDC_CHECK_AUTO_DEINTERLACE, m_checkAutoDeinterlace);
	DDX_Control(pDX, IDC_BUTTON_VIDEO_QUALITY, m_btnVideoQuality);
	DDX_Control(pDX, IDC_BUTTON_VIDEO_INPUT, m_btnVideoInput);
	DDX_Control(pDX, IDC_BUTTON_SNAPSHOT_BMP, m_btnSnapshot_bmp);
	DDX_Control(pDX, IDC_BUTTON_SNAPSHOT_JPG, m_btnSnapshot_jpg);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSetupDlg, CDialog)
	ON_WM_DESTROY()
	ON_WM_SYSCOMMAND()
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT_BMP, &CSetupDlg::OnBnClickedButtonSnapshotBmp)
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT_JPG, &CSetupDlg::OnBnClickedButtonSnapshotJpg)
	ON_BN_CLICKED(IDC_BUTTON_VIDEO_INPUT, &CSetupDlg::OnBnClickedButtonVideoInput)
	ON_BN_CLICKED(IDC_BUTTON_FILE_RECORDING, &CSetupDlg::OnBnClickedButtonFileRecording)
	ON_BN_CLICKED(IDC_BUTTON_AUDIO_INPUT, &CSetupDlg::OnBnClickedButtonAudioInput)
	ON_BN_CLICKED(IDC_BUTTON_SHARE_RECORDING, &CSetupDlg::OnBnClickedButtonShareRecording)
	ON_BN_CLICKED(IDC_BUTTON_VIDEO_QUALITY, &CSetupDlg::OnBnClickedButtonVideoQuality)
	ON_BN_CLICKED(IDC_CHECK_AUTO_DEINTERLACE, &CSetupDlg::OnBnClickedCheckAutoDeinterlace)
	ON_BN_CLICKED(IDC_CHECK_SHOW_CLONE_VIDEO, &CSetupDlg::OnBnClickedCheckShowCloneVideo)
END_MESSAGE_MAP()


// CSetupDlg message handlers

BOOL CSetupDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_editDeviceFormatInformation_1.SetWindowText( "INFO : ..." );

	m_editDeviceFormatInformation_2.SetWindowText( "INFO : ..." );

	m_editDeviceFormatInformation_3.SetWindowText( "INFO : ..." );

	m_editDeviceFormatInformation_4.SetWindowText( "INFO : ..." );

	CString strBmpFileNmae = m_pMainDialog->GetWorkingPath( "unnameX.bmp" );

	m_edit_bmp.SetWindowText( strBmpFileNmae );

	CString strJpgFileNmae = m_pMainDialog->GetWorkingPath( "unnameX.jpg" );

	m_edit_jpg.SetWindowText( strJpgFileNmae );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSetupDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here	
}

void CSetupDlg::OnSysCommand(UINT nID, LPARAM lParam) 
{
	// TODO: Add your message handler code here and/or call default

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	if ( nID == SC_CLOSE ) 
	{ 
		::SendMessage( AfxGetMainWnd()->m_hWnd, WM_SYSCOMMAND, SC_CLOSE, 0  );
    }

	CDialog::OnSysCommand(nID, lParam);
}

void CSetupDlg::OnBnClickedButtonSnapshotBmp()
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_pMainDialog->OnButtonSnapshotBMP_SetupDialog();
}

void CSetupDlg::OnBnClickedButtonSnapshotJpg()
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_pMainDialog->OnButtonSnapshotJPG_SetupDialog();
}

void CSetupDlg::OnBnClickedButtonVideoInput()
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_pMainDialog->OnButtonVideoInput_SetupDialog();
}

void CSetupDlg::OnBnClickedButtonFileRecording()
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_pMainDialog->OnButtonFileRecording_FileRecordDialog();
}

void CSetupDlg::OnBnClickedButtonAudioInput()
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_pMainDialog->OnButtonAudioInput_SetupDialog();
}

void CSetupDlg::OnBnClickedButtonShareRecording()
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_pMainDialog->OnButtonShareRecording_FileRecordDialog();
}

void CSetupDlg::OnBnClickedButtonVideoQuality()
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_pMainDialog->OnButtonVideoQuality_SetupDialog();
}

void CSetupDlg::OnBnClickedCheckAutoDeinterlace()
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_pMainDialog->OnCheckAutoDeinterlace_SetupDialog();
}

void CSetupDlg::OnBnClickedCheckShowCloneVideo()
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_pMainDialog->OnCheckShowCloneVideo_SetupDialog();
}
