/*************************************************

videocap.h
used by tw686x

**************************************************/

#ifndef VIDEOCAP_H
#define VIDEOCAP_H

int video_device_open (channel_t * channel);
int video_device_close (channel_t * channel);
int video_device_init (channel_t * channel);
int video_device_uninit (channel_t * channel);
int video_device_start (channel_t * channel);
int video_device_stop (channel_t * channel);
int video_device_getframe (channel_t * channel, void **frame_buf, int *frame_len);
int get_video_hue (channel_t * channel);
int set_video_hue (channel_t * channel, int hue);
int get_video_brightness (channel_t * channel);
int set_video_brightness (channel_t * channel, int brightness);
int get_video_colour (channel_t * channel);
int set_video_colour (channel_t * channel, int colour);
int get_video_contrast (channel_t * channel);
int set_video_contrast (channel_t * channel, int contrast);
int get_video_whiteness (channel_t * channel);
int set_video_whiteness (channel_t * channel, int whiteness);
int set_video_standard (channel_t * channel);
int set_video_resolution (channel_t * channel);
int set_video_input (channel_t * channel);
int set_video_framerate (channel_t * channel);
int get_video_framerate (channel_t * channel);
int get_video_signal (channel_t * channel);
int set_register( channel_t * channel, unsigned int addr, unsigned long val );
unsigned int get_register( channel_t * channel, unsigned int addr );
int save_registers( channel_t * channel, char* filename );

#endif /* VIDEOCAP_H */
