/*************************************************

xv_init.c
used by tw686x

**************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>		/* getopt_long() */

#include <fcntl.h>		/* low-level i/o */
#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include <asm/types.h>		/* for videodev2.h */
#include <linux/videodev2.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/Xvlib.h>

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include "tw686x.h"
#include "videocap.h"
#include "gui.h"
#include "xv_init.h"

int debug = 1;

void
xv_image_init (gui_t * gui)
{
  int i;
  unsigned int ver, rel, req, ev, err;

  if (Success != XvQueryExtension (gui->dpy, &ver, &rel, &req, &ev, &err))
    {
      if (debug)
	fprintf (stderr, "Xvideo: Server has no Xvideo extension support\n");
      return;
    }
  if (Success !=
      XvQueryAdaptors (gui->dpy, DefaultRootWindow (gui->dpy),
		       &(gui->adaptors), &(gui->ai)))
    {
      fprintf (stderr, "Xvideo: XvQueryAdaptors failed");
      return;
    }
  for (i = 0; i < gui->adaptors; i++)
    {
      if (!(gui->ai[i].type & XvInputMask))
	continue;
      if (!(gui->ai[i].type & XvImageMask))
	continue;
      if (Success != XvGrabPort (gui->dpy, gui->ai[i].base_id, CurrentTime))
	{
	  if (debug)
	    fprintf (stderr, "blit: xv: can't grab port %ld\n",
		     gui->ai[i].base_id);
	  continue;
	}
      if (debug)
	fprintf (stderr, "blit: xv: grabbed port %ld\n", gui->ai[i].base_id);
      gui->im_port = gui->ai[i].base_id;
      gui->im_adaptor = i;
      break;
    }
  if (UNSET == gui->im_port)
    return;

  gui->fo = XvListImageFormats (gui->dpy, gui->im_port, &(gui->formats));
  for (i = 0; i < gui->formats; i++)
    {
      if (debug)
	fprintf (stderr, "blit: xv: 0x%x (%c%c%c%c) %s",
		 gui->fo[i].id,
		 (gui->fo[i].id) & 0xff,
		 (gui->fo[i].id >> 8) & 0xff,
		 (gui->fo[i].id >> 16) & 0xff,
		 (gui->fo[i].id >> 24) & 0xff,
		 (gui->fo[i].format == XvPacked) ? "packed" : "planar");
      if (FMT_VIDEO_YUYV == gui->fo[i].id)
	{
	  gui->im_formats[VIDEO_YUYV] = gui->fo[i].id;
	  if (debug)
	    fprintf (stderr, " [ok:VIDEO_YUYV]");
	}
      if (FMT_VIDEO_UYVY == gui->fo[i].id)
	{
	  gui->im_formats[VIDEO_UYVY] = gui->fo[i].id;
	  if (debug)
	    fprintf (stderr, " [ok: VIDEO_UYVY]");
	}
      if (FMT_VIDEO_YUV420P == gui->fo[i].id)
	{
	  gui->im_formats[VIDEO_YUV420P] = gui->fo[i].id;
	  if (debug)
	    fprintf (stderr, " [ok: VIDEO_YUV420P]");
	}
      if (debug)
	fprintf (stderr, "\n");
    }
}

XvImage *
xv_create_ximage (gui_t * gui, int width, int height, int format)
{
  XvImage *xvimage = NULL;
  char *ximage_data;
  if (NULL == (ximage_data = (char *) malloc (width*height*2)))
    {
      fprintf (stderr, "out of memory\n");
      return NULL;
    }
  xvimage =
    XvCreateImage (gui->dpy, gui->im_port, format, ximage_data, width,
		   height);
  return xvimage;
}

void
xv_destroy_ximage (XvImage * xvimage)
{
  XFree (xvimage);
}
